# AI Agent Rules for Scala Projects

**⚠️ CRITICAL: Read this file completely before modifying any code**

## Workflow Overview

1. [Learning a New Codebase](#learning-a-new-codebase)
2. [Planning](#planning)
3. [Test](#test)
4. [Development](#development)
5. [Commit](#commit)

## Learning a New Codebase

1. Read the `README.md` file
2. Read the `CONTRIBUTING.md` file

## Planning

**⚠️ CRITICAL: Before modifying the code:**

1. **Discuss the plan** with the user
2. **Create a todo-list** of tasks
3. **Ask confirmation** before proceeding

## Test

Follow **Test-Driven Development** (TDD):

1. Write failing tests first
2. Implement the feature
3. Run tests (minimum 90% coverage)
4. Refactor

## Development

Follow Scala best practices and conventions.

## Commit

### Git Rules

**⚠️ CRITICAL:**
- ❌ NEVER `git stash`
- ❌ NEVER `git push` or `--force`
- ✅ ALWAYS ask user approval

### Commit Format

```
<type>(agt): <description>

Types: feat, fix, refac, chore, doc, test
```

---

**Remember**: Read this file completely before starting any work.
