# Contributing Guidelines

## Test-Driven Development Workflow

### 1. Red Phase: Write Failing Test

Write a test that fails.

### 2. Green Phase: Make it Pass

Implement the minimum code to pass the test.

### 3. Refactor Phase: Improve

Refactor while keeping tests green.

## Git Workflow

### Commit Format

```
<type>(agt): <description>

Types: feat, fix, refac, chore, doc, test
```

### Git Rules

**⚠️ CRITICAL:**
- ❌ NEVER `git stash`
- ❌ NEVER `git push` or `--force`
- ✅ ALWAYS ask user approval

## Code Review Checklist

- [ ] All tests pass
- [ ] Code coverage >= 90%
- [ ] No linter warnings
- [ ] Code is formatted
- [ ] Commit message follows format

---

**Remember**: Read [AGENTS_RULES.md](./AGENTS_RULES.md) before starting.
