# PHP Project - AI Agent Guidelines

**⚠️ CRITICAL: Read this file before starting any work**

## Quick Reference

This PHP project is a complete, autonomous setup with all necessary guidelines.

### Essential Documents (All in this directory)

1. **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete AI agent rules (works with all AI assistants)
2. **[.cursorrules](./.cursorrules)** - Quick reference for Cursor IDE (auto-loaded)
3. **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Code quality principles
4. **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guidelines
5. **[README.md](./README.md)** - Project template and setup guide

### Quick Start

- **For all AI agents**: Read [AGENTS_RULES.md](./AGENTS_RULES.md) for complete rules
- **For Cursor IDE**: The `.cursorrules` file is automatically loaded with a quick summary

---

## Workflow Summary

1. **Learning**: Read README.md and CONTRIBUTING.md
2. **Planning**: Discuss and get approval for todo-list
3. **Test**: Write tests first (TDD)
4. **Development**: Implement with PHP best practices
5. **Commit**: Only after tests pass (90% coverage) and user approval

---

## Key PHP Principles

- ✅ Test-Driven Development (TDD) - 90% minimum coverage
- ✅ Domain-Driven Design (DDD) - Business vocabulary first
- ✅ Result pattern - Railway-Oriented Programming
- ✅ Fail-fast error handling - No default values to mask issues
- ✅ Type safety - Wrap primitives in readonly classes
- ✅ Strict types - `declare(strict_types=1)` in EVERY file
- ✅ Readonly properties - For immutable value objects (PHP 8.1+)
- ✅ Enums - For closed sets of values (PHP 8.1+)
- ✅ Named arguments - For clarity
- ✅ PSR standards - Follow PHP-FIG standards
- ❌ Avoid mutable state
- ❌ Never use default values to mask missing data
- ❌ Never omit `declare(strict_types=1)`

---

## Build & Test Commands

```bash
# Composer
composer install
composer update

# PHPUnit
./vendor/bin/phpunit
./vendor/bin/phpunit --coverage-html coverage/

# Code quality
./vendor/bin/phpstan analyse src tests
./vendor/bin/php-cs-fixer fix
```

---

## Git Commit Format

All commits must use the `(agt)` prefix:

- `feat(agt):` - New feature
- `fix(agt):` - Bug fix
- `refac(agt):` - Refactoring
- `chore(agt):` - Cleanup
- `doc(agt):` - Documentation
- `test(agt):` - Tests only

**Remember**: Always ask permission before committing!

---

For complete details, see the [AGENTS_RULES.md](./AGENTS_RULES.md) file in this directory.
