# Perl Project - AI Agent Guidelines

**⚠️ CRITICAL: Read this file before starting any work**

## Quick Reference

This Perl project is a complete, autonomous setup with all necessary guidelines.

### Essential Documents (All in this directory)

1. **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete AI agent rules (works with all AI assistants)
2. **[.cursorrules](./.cursorrules)** - Quick reference for Cursor IDE (auto-loaded)
3. **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Code quality principles
4. **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guidelines
5. **[README.md](./README.md)** - Project template and setup guide

### Quick Start

- **For all AI agents**: Read [AGENTS_RULES.md](./AGENTS_RULES.md) for complete rules
- **For Cursor IDE**: The `.cursorrules` file is automatically loaded with a quick summary

---

## Workflow Summary

1. **Learning**: Read README.md and CONTRIBUTING.md
2. **Planning**: Discuss and get approval for todo-list
3. **Test**: Write tests first (TDD)
4. **Development**: Implement with Perl best practices
5. **Commit**: Only after tests pass (90% coverage) and user approval

---

## Key Perl Principles

- ✅ Use modern Perl (5.38+) with strict, warnings, and feature bundles
- ✅ Use Moose/Moo for object-oriented programming
- ✅ Use Type::Tiny for type constraints
- ✅ Use Result pattern for error handling
- ✅ Use Try::Tiny for exception handling
- ✅ Wrap primitives in value objects (no primitive obsession)
- ✅ Use subroutine signatures (Perl 5.36+)
- ✅ Use Roles for code reuse
- ❌ Avoid package variables
- ❌ Avoid bareword filehandles
- ❌ Avoid indirect object syntax
- ❌ Never use default values to mask missing data
- ❌ Avoid hash-based objects (use Moose/Moo)

---

## Build & Test Commands

```bash
# Build
perl Makefile.PL
make

# Run tests with coverage
cover -delete
PERL5OPT=-MDevel::Cover prove -l t/
cover

# Coverage threshold check (90% minimum)
cover -report text -coverage_threshold 90
```

**Note for WSL users**: Use `perl.exe` and `prove.exe` if targeting Windows Perl.

---

## Git Commit Format

All commits must use the `(agt)` prefix:

- `feat(agt):` - New feature
- `fix(agt):` - Bug fix
- `refac(agt):` - Refactoring
- `chore(agt):` - Cleanup
- `doc(agt):` - Documentation
- `test(agt):` - Tests only

**Remember**: Always ask permission before committing!

---

For complete details, see the `.cursorrules` file in this directory.
