# Kotlin Project - AI Agent Guidelines

**⚠️ CRITICAL: Read this file before starting any work**

## Quick Reference

This Kotlin project is a complete, autonomous setup with all necessary guidelines.

### Essential Documents (All in this directory)

1. **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete AI agent rules (works with all AI assistants)
2. **[.cursorrules](./.cursorrules)** - Quick reference for Cursor IDE (auto-loaded)
3. **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Code quality principles
4. **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guidelines
5. **[README.md](./README.md)** - Project template and setup guide

### Quick Start

- **For all AI agents**: Read [AGENTS_RULES.md](./AGENTS_RULES.md) for complete rules
- **For Cursor IDE**: The `.cursorrules` file is automatically loaded with a quick summary

---

## Workflow Summary

1. **Learning**: Read README.md and CONTRIBUTING.md
2. **Planning**: Discuss and get approval for todo-list
3. **Test**: Write tests first (TDD)
4. **Development**: Implement with Kotlin best practices
5. **Commit**: Only after tests pass (90% coverage) and user approval

---

## Key Kotlin Principles

- ✅ Test-Driven Development (TDD) - 90% minimum coverage
- ✅ Domain-Driven Design (DDD) - Business vocabulary first
- ✅ Result pattern - Railway-Oriented Programming
- ✅ Fail-fast error handling - No default values to mask issues
- ✅ Type safety - Use value classes (inline classes)
- ✅ Immutability - Use val and data classes
- ✅ Null safety - Leverage Kotlin's null safety features
- ✅ Coroutines - For asynchronous operations
- ✅ Modern Kotlin - Use Kotlin 1.9+ features
- ❌ Avoid mutable state (var)
- ❌ Never use default values to mask missing data
- ❌ Avoid !! (null assertion operator) - use safe calls instead

---

## Build & Test Commands

```bash
# Maven
mvn clean install
mvn test jacoco:report

# Gradle (recommended for Kotlin)
./gradlew clean build
./gradlew test jacocoTestReport
```

---

## Git Commit Format

All commits must use the `(agt)` prefix:

- `feat(agt):` - New feature
- `fix(agt):` - Bug fix
- `refac(agt):` - Refactoring
- `chore(agt):` - Cleanup
- `doc(agt):` - Documentation
- `test(agt):` - Tests only

**Remember**: Always ask permission before committing!

---

For complete details, see the [AGENTS_RULES.md](./AGENTS_RULES.md) file in this directory.
