# Code Quality Principles

**⚠️ CRITICAL: Read these principles before code reviews**

## 1. Write Tests First (TDD)

- Write failing tests before implementation
- Maintain 90% code coverage minimum
- Test business logic thoroughly

## 2. Keep It Simple

- Avoid over-engineering
- Write readable code
- Use clear naming conventions

## 3. Follow Language Conventions

- Use language-specific best practices
- Follow community standards
- Use recommended tools and patterns

## 4. Handle Errors Properly

- Never ignore errors
- Provide meaningful error messages
- Use appropriate error handling patterns

## 5. Write Clean Code

- Keep functions small and focused
- Avoid deep nesting
- Extract reusable code

## Summary

1. **TDD**: Write tests first
2. **Simplicity**: Keep it simple
3. **Conventions**: Follow standards
4. **Errors**: Handle properly
5. **Clean**: Write readable code
