# HTML/CSS AI Agent Configuration

## 🎨 Overview

This package contains AI agent configuration files for HTML/CSS development, focusing on semantic markup, modern CSS, accessibility, and responsive design.

## 📦 Package Contents

### Core Files

1. **`.cursorrules`** - Quick reference for Cursor IDE
2. **`AGENTS_RULES.md`** - Complete AI agent rules and guidelines
3. **`AGENTS.md`** - Quick reference guide for common patterns
4. **`CODE_QUALITY_PRINCIPLES.md`** - Code quality standards
5. **`CONTRIBUTING.md`** - Contribution guidelines
6. **`README.md`** - This file
7. **`.gitignore`** - Git exclusions for HTML/CSS projects

## 🚀 Quick Start

### For AI Agents (Cursor, Copilot, etc.)

1. **Download** this package
2. **Extract** to your project root
3. **Tell your AI agent**: 
   > "Read all .md files in this directory before starting. Follow the rules in AGENTS_RULES.md for all HTML/CSS code."

### For Developers

1. Review `AGENTS_RULES.md` for comprehensive guidelines
2. Check `.cursorrules` for quick reference
3. Follow patterns in `AGENTS.md`
4. Maintain quality standards from `CODE_QUALITY_PRINCIPLES.md`

## 🎯 Key Features

### HTML Best Practices
- ✅ Semantic HTML5 elements
- ✅ Accessibility (WCAG 2.1 AA)
- ✅ SEO optimization
- ✅ Valid markup

### CSS Best Practices
- ✅ Modern layouts (Grid, Flexbox)
- ✅ CSS Custom Properties
- ✅ BEM naming convention
- ✅ Mobile-first responsive design
- ✅ Performance optimizations

### Development Standards
- ✅ Cross-browser compatibility
- ✅ Accessibility testing
- ✅ Performance audits
- ✅ Code validation

## 🛠️ Recommended Tools

### Development
- **Build**: Vite, Webpack, Parcel
- **Preprocessors**: Sass, PostCSS
- **Linting**: Stylelint, HTMLHint
- **Formatting**: Prettier

### Testing
- **HTML**: W3C Validator, HTMLHint
- **CSS**: W3C CSS Validator, Stylelint
- **Accessibility**: axe DevTools, WAVE
- **Performance**: Lighthouse, PageSpeed Insights

### Browsers
- Chrome DevTools
- Firefox Developer Tools
- Safari Web Inspector
- Edge DevTools

## 📚 Documentation Structure

### Quick Reference
- `.cursorrules` - Essential rules for Cursor IDE
- `AGENTS.md` - Common patterns and examples

### Comprehensive Guides
- `AGENTS_RULES.md` - Complete rules and best practices
- `CODE_QUALITY_PRINCIPLES.md` - Quality standards
- `CONTRIBUTING.md` - How to contribute

## 🎨 Example Structure

```
project/
├── index.html
├── css/
│   ├── reset.css
│   ├── variables.css
│   ├── layout.css
│   ├── components.css
│   └── utilities.css
├── assets/
│   ├── images/
│   └── fonts/
└── js/
    └── main.js
```

## 🌐 Browser Support

- Chrome (last 2 versions)
- Firefox (last 2 versions)
- Safari (last 2 versions)
- Edge (last 2 versions)
- Mobile browsers (iOS Safari, Chrome Mobile)

## ♿ Accessibility

All code follows WCAG 2.1 AA guidelines:
- Semantic HTML structure
- Proper ARIA attributes
- Keyboard navigation
- Screen reader support
- Color contrast compliance

## 📱 Responsive Design

Mobile-first approach with breakpoints:
- Mobile: < 768px
- Tablet: 768px - 1023px
- Desktop: 1024px - 1279px
- Large Desktop: ≥ 1280px

## ⚡ Performance

Optimizations include:
- Critical CSS inlining
- Lazy loading images
- Modern image formats (WebP, AVIF)
- CSS and HTML minification
- Asset optimization

## 🤝 Contributing

See `CONTRIBUTING.md` for:
- How to propose changes
- Code review process
- Style guidelines
- Pull request template

## 📄 License

This configuration is provided as-is for use with AI coding assistants.

## 🔗 Related Resources

- [MDN Web Docs](https://developer.mozilla.org/)
- [W3C Standards](https://www.w3.org/standards/)
- [WCAG Guidelines](https://www.w3.org/WAI/WCAG21/quickref/)
- [Can I Use](https://caniuse.com/)
- [CSS-Tricks](https://css-tricks.com/)

## 📞 Support

For issues or questions:
1. Check `AGENTS_RULES.md` for detailed guidelines
2. Review `AGENTS.md` for common patterns
3. Consult `CODE_QUALITY_PRINCIPLES.md` for quality standards

---

**Version**: 1.0.0  
**Last Updated**: 2025-12-22  
**Package**: HTML/CSS AI Agent Configuration
