# F# Project Template

This directory contains a complete, autonomous AI Agent configuration for F# projects.

## For AI Agents

**Start here**: Read the [AGENTS_RULES.md](./AGENTS_RULES.md) file for complete rules.

All necessary guidelines are in this directory:
- **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete rules (works with all AI assistants)
- **[.cursorrules](./.cursorrules)** - Quick summary for Cursor IDE (auto-loaded)
- **[AGENTS.md](./AGENTS.md)** - Quick reference
- **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Quality principles
- **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guide

## For Developers

When starting a new F# project in this directory:

1. Follow the Quick Start guide below
2. Ensure the AI agent reads the `.cursorrules` file
3. Follow TDD and Domain-Driven Design principles

## Structure

- `.cursorrules` - Complete AI agent rules (auto-loaded by Cursor)
- `AGENTS.md` - Quick reference and links to full documentation
- `README.md` - This file

## Key Requirements

- **Test-Driven Development**: Write tests first
- **90% Code Coverage**: Minimum requirement
- **Domain-Driven Design**: Business vocabulary first
- **Railway-Oriented Programming**: Use Result types
- **No Mutable State**: Immutable by default
- **Type Safety**: Wrap primitives, use Option/Result

## Getting Started

```bash
# Create a new F# solution
dotnet.exe new sln -n YourProject

# Create projects
dotnet.exe new classlib -lang F# -o src/Domain
dotnet.exe new xunit -lang F# -o tests/DomainTests

# Add to solution
dotnet.exe sln add src/Domain/Domain.fsproj
dotnet.exe sln add tests/DomainTests/DomainTests.fsproj

# Add test reference
dotnet.exe add tests/DomainTests/DomainTests.fsproj reference src/Domain/Domain.fsproj

# Add required packages
dotnet.exe add src/Domain/Domain.fsproj package FSharp.Data
dotnet.exe add tests/DomainTests/DomainTests.fsproj package coverlet.collector
dotnet.exe add tests/DomainTests/DomainTests.fsproj package coverlet.msbuild
```

---

## Complete Documentation

All documentation is self-contained in this directory:

- **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete AI agent rules (universal)
- **[.cursorrules](./.cursorrules)** - Quick summary for Cursor IDE
- **[AGENTS.md](./AGENTS.md)** - Quick reference guide
- **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Code quality principles
- **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guidelines
- **[README.md](./README.md)** - This file

**Note**: This directory is completely autonomous and works with any AI assistant (Cursor, GitHub Copilot, ChatGPT, Claude, etc.).
