# F# Project - AI Agent Guidelines

**⚠️ CRITICAL: Read this file before starting any work**

## Quick Reference

This F# project is a complete, autonomous setup with all necessary guidelines.

### Essential Documents (All in this directory)

1. **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete AI agent rules (works with all AI assistants)
2. **[.cursorrules](./.cursorrules)** - Quick reference for Cursor IDE (auto-loaded)
3. **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Code quality principles
4. **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guidelines
5. **[README.md](./README.md)** - Project template and setup guide

### Quick Start

- **For all AI agents**: Read [AGENTS_RULES.md](./AGENTS_RULES.md) for complete rules
- **For Cursor IDE**: The `.cursorrules` file is automatically loaded with a quick summary

---

## Workflow Summary

1. **Learning**: Read README.md and CONTRIBUTING.md
2. **Planning**: Discuss and get approval for todo-list
3. **Test**: Write tests first (TDD)
4. **Development**: Implement with F# best practices
5. **Commit**: Only after tests pass (90% coverage) and user approval

---

## Key F# Principles

- ✅ Use Railway-Oriented Programming (Result types)
- ✅ Use async workflows for I/O
- ✅ Wrap primitives in types (no primitive obsession)
- ✅ Use Option instead of null
- ✅ Prefer Result over exceptions
- ❌ Never use mutable state
- ❌ Never use default values to mask missing data

---

## Build & Test Commands

```bash
# Build
dotnet.exe build

# Run tests with coverage
dotnet.exe test --filter "Category!=End2EndPipelineTests" /p:CollectCoverage=true /p:CoverletOutputFormat=cobertura /p:ExcludeByAttribute="GeneratedCodeAttribute"
```

---

## Git Commit Format

All commits must use the `(agt)` prefix:

- `feat(agt):` - New feature
- `fix(agt):` - Bug fix
- `refac(agt):` - Refactoring
- `chore(agt):` - Cleanup
- `doc(agt):` - Documentation
- `test(agt):` - Tests only

**Remember**: Always ask permission before committing!

---

For complete details, see the `.cursorrules` file in this directory.
