# C# Project Template

This directory contains a complete, autonomous AI Agent configuration for C# projects.

## For AI Agents

**Start here**: Read the [AGENTS_RULES.md](./AGENTS_RULES.md) file for complete rules.

All necessary guidelines are in this directory:
- **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete rules (works with all AI assistants)
- **[.cursorrules](./.cursorrules)** - Quick summary for Cursor IDE (auto-loaded)
- **[AGENTS.md](./AGENTS.md)** - Quick reference
- **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Quality principles
- **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guide

## For Developers

When starting a new C# project in this directory:

1. Follow the Quick Start guide below
2. Ensure the AI agent reads the `.cursorrules` file
3. Follow TDD and Domain-Driven Design principles

## Structure

- `.cursorrules` - Complete AI agent rules (auto-loaded by Cursor)
- `AGENTS.md` - Quick reference and links to full documentation
- `README.md` - This file

## Key Requirements

- **Test-Driven Development**: Write tests first
- **90% Code Coverage**: Minimum requirement
- **Domain-Driven Design**: Business vocabulary first
- **Result Pattern**: Use Result types for error handling
- **Immutability**: Use records and readonly properties
- **Type Safety**: Wrap primitives, use nullable reference types
- **Modern C#**: Use C# 12+ features (records, pattern matching, required)

## Getting Started

```bash
# Create a new C# solution
dotnet.exe new sln -n YourProject

# Create projects
dotnet.exe new classlib -o src/Domain
dotnet.exe new xunit -o tests/DomainTests

# Add to solution
dotnet.exe sln add src/Domain/Domain.csproj
dotnet.exe sln add tests/DomainTests/DomainTests.csproj

# Add test reference
dotnet.exe add tests/DomainTests/DomainTests.csproj reference src/Domain/Domain.csproj

# Add required packages
dotnet.exe add src/Domain/Domain.csproj package System.Text.Json
dotnet.exe add tests/DomainTests/DomainTests.csproj package coverlet.collector
dotnet.exe add tests/DomainTests/DomainTests.csproj package coverlet.msbuild
dotnet.exe add tests/DomainTests/DomainTests.csproj package FluentAssertions
dotnet.exe add tests/DomainTests/DomainTests.csproj package Moq
```

## Enable Modern C# Features

Update your `.csproj` files:

```xml
<PropertyGroup>
  <TargetFramework>net8.0</TargetFramework>
  <LangVersion>12</LangVersion>
  <Nullable>enable</Nullable>
  <ImplicitUsings>enable</ImplicitUsings>
  <TreatWarningsAsErrors>true</TreatWarningsAsErrors>
</PropertyGroup>
```

---

## Complete Documentation

All documentation is self-contained in this directory:

- **[AGENTS_RULES.md](./AGENTS_RULES.md)** - Complete AI agent rules (universal)
- **[.cursorrules](./.cursorrules)** - Quick summary for Cursor IDE
- **[AGENTS.md](./AGENTS.md)** - Quick reference guide
- **[CODE_QUALITY_PRINCIPLES.md](./CODE_QUALITY_PRINCIPLES.md)** - Code quality principles
- **[CONTRIBUTING.md](./CONTRIBUTING.md)** - Contribution guidelines
- **[README.md](./README.md)** - This file

**Note**: This directory is completely autonomous and works with any AI assistant (Cursor, GitHub Copilot, ChatGPT, Claude, etc.).
